# Contraceptive Provision Measures

## Technical Documentation: Claims Code Sets

To view OPA-defined contraceptive method and condition codes by year, click on the following links:

- [2019 Excel file](https://opa.hhs.gov/claims-data-sas-program-instructions)
- [2018 Excel file](https://opa.hhs.gov/claims-data-sas-program-instructions)
- [2017 Excel file](https://opa.hhs.gov/claims-data-sas-program-instructions)
- [Pre-2017 Excel file](https://opa.hhs.gov/claims-data-sas-program-instructions)

These files are for analyst reference only and are not required by the SAS programs.

## User Guide for SAS Programs (v5.01)

The Statistical Analysis System (SAS®) programs for Contraceptive Provision Performance Measures are provided in a download link below. These updated version 3.01 programs are valid for calculating measures from years 2013 up to the current measurement year. These programs can automatically download the correct claims code lookup tables from the OPA website for a user-specified year of measurement. The programs are usable for claims data having ICD-9, ICD-10, or mixed code sets (such as the transition year 2015 with both types). 

Although they will no longer receive updates, the previous versions of the SAS Programs (v2.01, v1.03a) are still available so that users can reproduce historical reports of contraceptive provision rates (the download links appear at the bottom of this guide). Please note that 2018 measure rates calculated with v1.03a SAS programs are not directly comparable to 2013-2017 data years. That is because the v.103a 2013-2017 claims code tables use ICD-9 and ICD-10 procedure codes and ICD-9 diagnosis codes to flag live birth events, whereas the specifications were revised with the 2018 claims code tables to also include ICD-10 diagnosis codes for live births. The 2018 tables also exclude diagnosis and procedure codes related to labor, delivery, and postpartum care to flag pregnancy. 

It is highly recommended that users download and use the most current version of the SAS Programs (v5.01 – linked below) for measure calculation, since it uses the latest specifications for the contraceptive provision measures.

## Defining the Eligible Population

The OPA provided SAS Programs (v5.01) are able to calculate contraceptive provision measures among all continuously enrolled and family planning waiver recipients, -or- among postpartum women (but not both at the same time). Because these eligible populations are different, calculating both types of measures require the use of different datasets.

### To calculate the contraceptive provision measures among all women of reproductive age:

Your claims dataset should consist entirely of women ages 15-44 years. The dataset should include:

- a) General Medicaid recipients who are continuously enrolled in the measurement year, defined as no more than one gap in enrollment of up to 45 days during the continuous enrollment period, and
- b) Family Planning Waiver recipients (regardless of continuous enrollment).

For cases of continuously enrolled women having no claims in the measurement year, add a single record to the dataset with a unique Patient ID, Date of Birth (or age if DOB is not available), and January 1 assigned as the Date of Service (enabling these cases to be included in the denominator).

Your input dataset should represent a single calendar year of data; women outside of the ages 15-44 years as well as records without dates occurring in the measurement year are automatically excluded from the analysis.

### To calculate contraceptive provision measures among postpartum women:

A similarly formatted dataset should be used, with one important difference. The dataset must include ALL women ages 15-44 years -- regardless of enrollment status. Continuous enrollment is not required for postpartum measures, because women remain enrolled in Medicaid for their entire 60-day postpartum measurement period.

## Data Requirements 

Your input SAS dataset must be at the claims level (multiple records per woman per encounter, each record being a separate claim) and contain the following types of variables:

- Unique Patient ID; 
- Date of service (for continuously enrolled recipients without claims, January 1 should be assigned as the date of service); 
- Patient date of birth (DOB); If patient DOB is unavailable, you may specify the patient’s age at date of service. 
- Diagnosis, Procedure, and Drug code variables, each having a unique prefix for each type of code, for example: 
  - International Classification of Diseases (ICD) diagnosis code variables: ICD1, ICD2, ICD3, ICD4, … 
  - Procedure (Proc) code variables: PROC1, PROC2, … 
  - National Drug Code (NDC) variables (in 11-character format): NDC1, NDC2,...

## Steps to run programs

1. Clone this repo and download the .sas files

2. Edit 00.setup.sas as follows: 
- In the USER SETUP section, carefully follow the notes for editing (denoted by *…Edit ONLY) found inside the program. The following edits are required for the programs to run:    - The location where the programs have been saved (in the filename statement), and where your input data is saved (the data_dir macro variable). 
   - The name of your input dataset (DSN), measurement year of claims data (Year), and variable names for unique PatientID, PatientDOB, and DateOfService. Choose the correct dataset as eligibility requirements differ for calculating measures in all women at reproductive age versus in postpartum women only. 
   - Prefixes of the variables used for diagnosis, procedure, and drug codes. Each of these types of claims variables should have a unique prefix (for example, the set of diagnosis codes

- The following edits are optional: 

  - To stratify measure reporting, add your demographic variables to the macro variable stratifying_var_list. These variables must be found in your input dataset. Specify the stratification variable names as a list with spaces, e.g. stratifying_var_list = race education. 
  - If patient date of birth is not available, you can use patient’s age at date of service for age exclusions by specifying UseSvcAgeforExclusions = Y, and the variable name for patient age at date of service, e.g., Ageatdateofservice = EncounterAge. 
  - To perform additional measure calculations within the postpartum population, you must first change the dataset according to the eligibility requirements. Specify postpartum = Y and the number of day(s) postpartum at which to do calculation in the dayspp_list = macro variable. If postpartum = N or left blank (or something other than Y is entered), then postpartum calculations will not be reported, and a note will appear in the log. If postpartum = Y and dayspp_list is left blank, the default is 3- and 90-days postpartum.

3. Highlight only the top section of 00.setup.sas down through the %include OPA(“setup_helper.sas”); and run it. The setup_helper.sas program will check that your input data meet the minimum requirements and prepare these data for the analysis. Variables are converted into the required formats so that the SAS programs will work properly. The setup_helper.sas program will create a pop-up window with information about the process. If this window does not appear above your current window, look for a tab named SETUP_HELPER at the bottom of your SAS session window, and click on the tab to view it.

- The SETUP_HELPER window will show these details about your data:

  - Total claims, total patients, and average number of claims per patient 
  - The prefixes for the diagnosis, procedure, and drug codes 
  - Optional user choices for the postpartum measures, exclusions based on age at last service, and report stratification variables 
  - Your SAS version, and whether the lookup tables can be downloaded automatically 
  - Location and name of a zip file that can be used for troubleshooting

- After reviewing the above details, hit the ENTER key to continue. The DATA_CHECKS window now displays information about required measure calculation variables, including:

  - The date of service variable name, format, range of values, and the number of records to be dropped due to missing values 
  - The age variable name, format, and range of values (calculated as of Dec 31 of the measurement year from Patient DOB, or Age At Last Service Date) 
  - The drug code variable name, format, and range of value lengths (these should be in the 11-character NDC standard)

- After reviewing the above details, hit the ENTER key to continue, and the DATA_CHECKS window will close. The setup information is also printed in the SAS log. A small deidentified sample, log file and list of variables from the analysis dataset are saved in a zip file (in the same location as input data).

- Your analysis dataset is now ready to use with programs 01-05.

4. Download the claims code lookup tables. The SETUP_HELPER informed you if SAS can automatically download the tables.

- For SAS versions 9.4 and above:

  - Simply run the DOWNLOAD THE LATEST LOOKUP TABLES WITH CONTRACEPTIVE CLAIMS CODES section of 00.setup.sas. The lookup tables are automatically downloaded from the OPA website for the year specified and saved to your SAS WORK library. If you run into problems with this method, you can also download the lookup tables manually (follow directions below for versions of SAS 9.3 and earlier).

- For SAS version 9.3 and earlier, SAS claims code lookup tables must be downloaded manually, unzipped, and saved to your SAS Work library.

- For data year 2020, the lookup tables are here: [contraceptive-lookup-tables-v3-2020.zip (76 KB)](https://opa.hhs.gov/sites/default/files/2021-08/contraceptive-lookup-tables-v3-2020.zip) 
- For data year 2019, the lookup tables are here: [contraceptive-lookup-tables-v3-2019.zip (94 KB)](https://opa.hhs.gov/sites/default/files/2021-01/contraceptive-lookup-tables-v3-2019.zip) 
- For data year 2018, the lookup tables are here: [contraceptive-lookup-tables-v3-2018.zip (88 KB)](https://opa.hhs.gov/sites/default/files/2021-01/contraceptive-lookup-tables-v3-2018.zip)
- For data year 2017, the lookup tables are here: [contraceptive-lookup-tables-v3-2017.zip (88 KB)](https://opa.hhs.gov/sites/default/files/2021-01/contraceptive-lookup-tables-v3-2017.zip)
- For data years 2013-2016, the lookup tables are here: [contraceptive-lookup-tables-v3-pre-2017.zip (357 KB)](https://opa.hhs.gov/sites/default/files/2020-12/contraceptive-lookup-tables-v3-pre-2017.zip)

5. Once the claims code lookup tables have been downloaded into your work directory, you are ready to calculate the measures. Simply run the final %include commands found in the last section of 00.setup.sas. These commands execute programs 01-05 and calculate the measures. Alternately you can submit each program 01-05 yourself from the editor window, in sequence.

Should you wish to reproduce previous reports of contraceptive provision rates, you may download the previous versions of the SAS Programs (v1.03a or v2.01) and claims code lookup tables below. Please be aware of the caveats on the incomparability of rates as noted in the first few paragraphs of this guide.

- [contraceptive-progs-lookup-v1.03a.zip (1,016 KB)](https://opa.hhs.gov/sites/default/files/2020-08/contraceptive-progs-lookup-v1.03a.zip)
- [contraceptive-progs-lookup-v2.01.zip (1,119 KB)](https://opa.hhs.gov/sites/default/files/2020-12/contraceptive-progs-lookup-v2.01.zip)





